/* ==========================================================

Please review the /readme-productCategory.md for a more details.

========================================================== */
const jsonURL = document.querySelector("#product-detail-wrapper").dataset.path;

// URL from which to fetch the JSON data
const url = jsonURL;
function renderItem(item) {
  const productDetails = item.productDetails.map(detail => {
    return `<li><span>${detail.productDetailDisplayLabel}:</span> ${detail.productDetailFieldValue.plaintext}</li>`;
  }).join('');

  const applications = item.localizedProductFeature.applications;

  const specifications = item.productSpecification.map(spec => {
    return `<li><span>${spec.specificationLabel}</span> ${spec.specifcationMeasureImperial} | ${spec.specifcationMeasureMetric}</li>`;
  }).join('');

  const resources = item.productResources.map(res => {
    return res.resourceLabel ? `<li><span>${res.resourceLabel}:</span> <a title="${res.resourceLabel}" href="${res.resourceLink ? res.resourceLink._publishUrl : '#'}">${res.resourceLink ? res.resourceLink._publishUrl : '#'}</a></li>` : '';
  }).join('');

  // Sort and group productImages by imageCategory
  const sortedImages = [...item.productImages].sort((a, b) => a.imageCategory.localeCompare(b.imageCategory));

  const images = sortedImages.reduce((acc, imageGroup) => {
    const category = imageGroup.imageCategory;
    if (!acc[category]) {
      acc[category] = [];
    }
    acc[category].push(imageGroup);
    return acc;
  }, {});

  const imageHtml = Object.keys(images).map(category => {
    const variantsHtml = images[category].map(imageGroup => {
      const variantBlocks = imageGroup.imageVariants.map(variant => {
        return `
                  <li><a href="${variant.imageLink}" title="${variant.imageLabel}" target="_blank">${variant.imageLabel} <i class="fas fa-link"></i></a></li>
          `;
      }).join('');
      return `<div class="product-image-group"><img src="${imageGroup.imageThumbnail}" alt="${imageGroup.imageCategory}" /><ul>${variantBlocks}</ul></div>`;
    }).join('');
    return `<div class="image-section"><h3>${category}</h3><div class="product-image-variants">${variantsHtml}</div>`;
  }).join('');

  function replacePipeWithComma(className) {
    // Select all elements with the specified class
    const elements = document.getElementsByClassName(className);
  
    // Loop through each element
    for (let i = 0; i < elements.length; i++) {
      const element = elements[i];
  
      // Replace the pipe character with a comma in the element's text content            
      element.textContent = element.textContent.replace(/\s\|\s/g, ', ');
      
    }
  }
  
  // Example usage:
  replacePipeWithComma("replaceME");

  const template = `       
                <div class="content">
                  <div class="product-section">
                      <div class="single-product">
                      
                      <img class="api-image" style="width:300px; max-width:100%;" src="${item.productImages[0].imageVariants[0].imageLink}"></img>
                        <h2 class="api-text">${item.productSeries.seriesId}</h2>
                        <h4 class="api-text">${item.productDetails[1].productDetailFieldValue.plaintext}</h4>
                        <p class="api-text">${item.productSpecification[0].specificationLabel}: ${item.productSpecification[0].specifcationMeasureImperial}</p>
                        <p class="api-text">${item.productSpecification[1].specificationLabel}: ${item.productSpecification[1].specifcationMeasureImperial}</p>
                        <div class="replaceME"><p class="api-text">${item.localizedProductFeature.applicationsDisplayLabel}: ${item.localizedProductFeature.applications}</p></div>
                        <a href="${item.productResources[0].resourceLink._publishUrl}">Call To Action</a>
                      </div>
                  </div>
              </div>
          `;
  return template;
};
// Function to render HTML template
function displayData(data) {
  const items = data.data.baseProductList.items;

  // Loops through list of items in JSON
  for (let i = 0; i < items.length; i++) {
    let item = items[i];
    //if statement checks for type of truck and returns if True.
    if (item.localizedProductFeature.forkliftType == "Stackers") {
      template = renderItem(item);
      document.getElementById('data-container').innerHTML += template;
    };
  };


}

fetch(url)
  .then(response => {
    if (!response.ok) {
      throw new Error('Network response was not ok ' + response.statusText);
    }
    return response.json();
  })
  .then(data => {
    displayData(data);
  })
  .catch(error => {
    document.getElementById('data-container').innerHTML = '<p>Error loading data. Please try again later.</p>';
    console.error('Fetch error:', error);
  });
